---
generated_at: 2026-01-21 10:35:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：12-Region Plugin.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **C-18**: qa_rules_tの型定義詳細 - 型定義ファイル未確認
  2. **C-25**: QA_RULESテーブルのカラム定義詳細 - DDL未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/apex/f141/application/pages/page_00020.sql` (行1-174)
- E-02: `src/apex/plugin/region_type_plugin_quasto_region.sql` (行1-310)
- E-03: `src/plsql/pkg/qa_apex_api_pkg.sql` (行1-236)
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv` (行13)
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md` (行16, 38-40, 78-79)
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` (行29-31)

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Page IDは20である | E-01 (行15) | ○ |
| C-02 | Page Aliasは'REGION-PLUGIN'である | E-01 (行17) | ○ |
| C-03 | Page Modeは通常ページである | E-01 (行14-23 - p_page_mode指定なし) | ○ |
| C-04 | Protection Levelは'C'である | E-01 (行21) | ○ |
| C-05 | P20_CLIENT_NAMEはSelect Listである | E-01 (行132) | ○ |
| C-06 | P20_CLIENT_NAME LOVはqa_rulesからAPEXカテゴリを抽出 | E-01 (行133-136) | ○ |
| C-07 | P20_RULE_SELECTIONはSelect Listである | E-01 (行152) | ○ |
| C-08 | P20_RULE_SELECTIONはP20_CLIENT_NAMEでカスケード | E-01 (行161) | ○ |
| C-09 | P20_APP_IDはSelect Listである | E-01 (行86) | ○ |
| C-10 | P20_APP_ID LOVはapex_applicationsから取得 | E-01 (行88-92) | ○ |
| C-11 | P20_APP_PAGE_IDはSelect Listでカスケード | E-01 (行108, 116-117) | ○ |
| C-12 | 全Select Listはサブミット時に更新 | E-01 (行99, 123, 143, 168) | ○ |
| C-13 | プラグイン名はPLUGIN_QUASTO_REGION | E-01 (行72) | ○ |
| C-14 | プラグインはattribute_01-04で4つのパラメータを受け取る | E-01 (行74-78), E-02 (行205-250) | ○ |
| C-15 | render_qa_region関数がプラグインのレンダリングを担当 | E-02 (行61-194, 197) | ○ |
| C-16 | qa_apex_api_pkg.tf_run_rulesが呼び出される | E-02 (行170-174) | ○ |
| C-17 | 結果はHTMLテーブル形式で出力される | E-02 (行96-106, 128-136) | ○ |
| C-18 | qa_rules_t型でルール実行結果を返却 | E-02 (行71-72), E-03 | △ |
| C-19 | tf_run_rulesはAPEXカテゴリのルールのみ実行 | E-03 (行206-211) | ○ |
| C-20 | tf_run_ruleはEXECUTE IMMEDIATEでルールSQLを実行 | E-03 (行143-167) | ○ |
| C-21 | ブラックリスト除外処理が実行される | E-03 (行41-96, 156) | ○ |
| C-22 | 関連機能No.2, 24, 3が紐づく | E-06 (行29-31) | ○ |
| C-23 | GitHubリポジトリURLはhttps://github.com/mt-ag/quasto | E-01 (行44-45), E-02 (行202) | ○ |
| C-24 | プラグインCSSファイルが含まれる | E-02 (行59, 253-299) | ○ |
| C-25 | QA_RULESテーブルにqaru_category, qaru_sqlカラムが存在 | E-03 (行141, 143, 206-208) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-18**: qa_rules_t型の詳細定義
  - コード内でqa_rules_tが使用されているが、TYPE定義ファイルを直接確認していない
  - 候補：`src/plsql/type/qa_rules_t.sql` / `src/plsql/type/qa_rule_t.sql`

- **C-25**: QA_RULESテーブルのDDL
  - パッケージコードから推測されるカラムは確認できるが、完全なテーブル定義は未確認
  - 候補：`src/plsql/tbl/qa_rules.sql` / `src/plsql/ddl/qa_rules.sql`

## 5) リスクフラグ（レビュー観点）
- **0（低リスク）**: プラグイン実装とAPI呼び出しは明確にコードで確認できる。
- **1（中リスク）**: データ型定義（qa_rules_t）の詳細はTYPEファイルで確認が望ましい。

## 6) レビュアーチェックリスト（最小）
- [ ] qa_rules_t, qa_rule_t型の定義を確認し、設計書の列定義と一致しているか
- [ ] プラグインのattribute_01-04がページ定義と正しくマッピングされているか
- [ ] tf_run_rulesがAPEXメタデータビューへのアクセス権限を持っているか確認
- [ ] p_exclude_not_whitelisted_apex_entriesのブラックリストビュー（qa_apex_blacklisted_apps_v）の定義を確認
- [ ] プラグインCSSがページ表示で正しく読み込まれるか確認
